package edu.unl.consystlab.sudokuConstructor.consistencyAlgorithms;

import java.util.LinkedList;
import java.util.List;

import edu.unl.consystlab.sudokuSolver.constraintProblem;
import edu.unl.consystlab.sudokuSolver.problemConstraint;

public abstract class consistencyAlgorithm {

	protected constraintProblem parentProblem;
	protected problemConstraint brokenConstraint;
	protected List variableReductions;
	protected boolean encounteredError;
	
	public consistencyAlgorithm(constraintProblem newProblem)
	{
		parentProblem = newProblem;
		brokenConstraint = null;
		variableReductions = new LinkedList();
		encounteredError = false;
	}
	
	//returns true if the algorithm succeeds, false otherwise.
	public boolean runAlgorithm()
	{
		return false;
	}

	public void setBrokenConstraint(problemConstraint brokenConstraint) {
		this.brokenConstraint = brokenConstraint;
	}

	public problemConstraint getBrokenConstraint() {
		return brokenConstraint;
	}

	public void setVariableReductions(List variableReductions) {
		this.variableReductions = variableReductions;
	}

	public List getVariableReductions() {
		return variableReductions;
	}

	public void setEncounteredError(boolean encounteredError) {
		this.encounteredError = encounteredError;
	}

	public boolean isEncounteredError() {
		return encounteredError;
	}
	
	
}
